#!/bin/bash

# Set the environment variables first before running the command.
export HF_ALLOW_CODE_EVAL=1
export HF_DATASETS_TRUST_REMOTE_CODE=true

TASK="tinyGSM8k"
MODEL_PATH="GSAI-ML/LLaDA-8B-Instruct"
MODEL_NAME="llada_instruct"
GEN_LENGTH=512
INIT_BLOCK_LENGTH=32
CONFIDENCE_THRESHOLD=0.3
LOG_DIR="logs/tinyGSM8k/tinyGSM8k_semantic_prefix_cache_llada_instruct_512"

# no cache
accelerate launch --num_processes=1 eval_llada_semantic.py --tasks ${TASK} --num_fewshot 5 \
    --confirm_run_unsafe_code --model llada_dist \
    --model_args model_path=${MODEL_PATH},gen_length=${GEN_LENGTH},steps=${steps},block_length=${INIT_BLOCK_LENGTH},threshold=0.9,confidence_threshold=${CONFIDENCE_THRESHOLD},show_speed=True 

# prefix cache
accelerate launch --num_processes=1 eval_llada_semantic.py --tasks ${TASK} --num_fewshot 5 \
    --confirm_run_unsafe_code --model llada_dist \
    --model_args model_path=${MODEL_PATH},gen_length=${GEN_LENGTH},steps=${steps},block_length=${INIT_BLOCK_LENGTH},threshold=0.9,confidence_threshold=${CONFIDENCE_THRESHOLD},show_speed=True,use_cache=true 

# dual cache
accelerate launch --num_processes=1 eval_llada_semantic.py --tasks ${TASK} --num_fewshot 5 \
    --confirm_run_unsafe_code --model llada_dist \
    --model_args model_path=${MODEL_PATH},gen_length=${GEN_LENGTH},steps=${steps},block_length=${INIT_BLOCK_LENGTH},threshold=0.9,confidence_threshold=${CONFIDENCE_THRESHOLD},show_speed=True,use_cache=true,dual_cache=true 